TTweet = enchant.Class.create(enchant.Sprite, {
	initialize : function(w, h) {
		this.lifetime = 0;
		enchant.Sprite.call(this, w, h + TTweet.TAIL);
		this.image = new Surface(w, h + TTweet.TAIL);
		var t = TTweet.TAIL;
		var s = TTweet.SIZE;
		var c = TTweet.CURVE;
		this.outCurve = {
			lt : {x:  0, y:  t},
			rt : {x:  w, y:  t},
			rd : {x:  w, y:h+t},
			ld : {x:  0, y:h+t}
		};
		this.inCurve = {
			lt : {x:  0+s, y:  t+s},
			rt : {x:  w-s, y:  t+s},
			rd : {x:  w-s, y:h+t-s},
			ld : {x:  0+s, y:h+t-s}
		};
		this.image.context.font = "12px 'Times New Roman'";
		this.addEventListener('enterframe', function(){
			if((this.age % 15) == 0){
				this.lifetime--;
			}
			if(this.lifetime <= 0){
				this.lifetime = 0;
				this.opacity = 0;
			}
		});
	},
	reDraw : function() {
		var c = TTweet.CURVE;
		var o = this.outCurve;
		with(this.image.context) {
			fillStyle = 'black';
			strokeStyle = 'black';
			beginPath();
			moveTo(o.lt.x, o.lt.y+c);
			quadraticCurveTo(o.lt.x, o.lt.y, o.lt.x+c, o.lt.y);
			lineTo(o.rt.x-c, o.rt.y);
			quadraticCurveTo(o.rt.x, o.rt.y, o.rt.x, o.rt.y+c);
			lineTo(o.rd.x, o.rd.y-c);
			quadraticCurveTo(o.rd.x, o.rd.y, o.rd.x-c, o.rd.y);
			lineTo(o.ld.x+c, o.ld.y);
			quadraticCurveTo(o.ld.x, o.ld.y, o.ld.x, o.ld.y-c);
			// しっぽ
			// var _height = 100;
			// lineTo(this.width/2-4,_height + TTweet.TAIL);
			// lineTo(this.width/2,_height + 0);
			// lineTo(this.width/2+4,_height + TTweet.TAIL);
			closePath();
			fill();
			stroke();
		};
		this.clear();
	},
	clear : function() {
		var c = TTweet.CURVE;
		var o = this.outCurve;
		var i = this.inCurve;
		with(this.image.context) {
			// 抜く
			fillStyle = 'white';
			beginPath();
			moveTo(i.lt.x, o.lt.y+c);
			quadraticCurveTo(i.lt.x, i.lt.y, o.lt.x+c, i.lt.y);
			lineTo(o.rt.x-c, i.rt.y);
			quadraticCurveTo(i.rt.x, i.rt.y, i.rt.x, o.rt.y+c);
			lineTo(i.rd.x, o.rd.y-c);
			quadraticCurveTo(i.rd.x, i.rd.y, o.rd.x-c, i.rd.y);
			lineTo(o.ld.x+c, i.ld.y);
			quadraticCurveTo(i.ld.x, i.ld.y, i.ld.x, o.ld.y-c);
			closePath();
			fill();
		};
	},
	text : function(text, x, y) {
		this.clear();
		this.opacity = 0.8;

		this.reDraw();
		with(this.image.context) {
			// var size = measureText(text);
			fillStyle = 'black';
			textAlign = 'center';
			textBaseline = 'middle';
			this.x = x;
			this.y = y;
			// fillText(text,this.width/2,this.height/2);
			// console.log(size);
			// this.width = size;
			// console.log(this.width);
			// this.reDraw();
			this.fillTextLine(text,this.width/2,this.height/2);
		}
		this.lifetime = 7;

	},
	fillTextLine : function(text, x, y) {
		var textList = text.split("\n");
		var lineHeight = this.image.context.measureText("あ").width + 2;
		var self = this;
		textList.forEach(function(text, i) {
			self.image.context.fillText(text, x, y + lineHeight * i);
		});
	},


});
TTweet.TAIL  =  8;
TTweet.SIZE  =  2;
TTweet.CURVE = 16;

//how to use
//var tweet = new TTweet(128, 64);
//tweet.text("ABCDEFG");